<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class One_vs_One_Battles extends Model
{
    use HasFactory;

    protected $table = 'tbl_one_vs_one_battles';
    protected $guarded = array();

    protected $casts = [
        'id' => 'integer',
        'room_code' => 'string',
        'name' => 'string',
        'question_ids' => 'string',
        'total_questions' => 'integer',
        'joining_coin' => 'integer',
        'winning_coin' => 'integer',
        'is_full' => 'integer',
        'c_user_id' => 'integer',
        'c_questions_attended' => 'integer',
        'c_correct_answers' => 'integer',
        'c_percentage' => 'integer',
        'j_user_id' => 'integer',
        'j_questions_attended' => 'integer',
        'j_correct_answers' => 'integer',
        'j_percentage' => 'integer',
        'w_user_id' => 'integer',
        'l_user_id' => 'integer',
        'status' => 'integer',
    ];

    public function c_user()
    {
        return $this->belongsTo(User::class, 'c_user_id');
    }
    public function j_user()
    {
        return $this->belongsTo(User::class, 'j_user_id');
    }
    public function w_user()
    {
        return $this->belongsTo(User::class, 'w_user_id');
    }
    public function l_user()
    {
        return $this->belongsTo(User::class, 'l_user_id');
    }
}
